//------------------------------------------------------------------------------
// File: svr_taskruler.cs
// This file contains console methods of the TaskRuler class
// Author: Matthew Rudge
//------------------------------------------------------------------------------

function TaskRuler::canMarkAvailable(%this, %vertex)
{
   if(!isObject(%vertex))
     return false;
   
   // Get the number of parents of the vertex
   %numParents = %vertex.getParentCount();
   
   // For each parent do
   %canMark = true;
   for(%i = 0; %i < %numParents; %i++)
   {
      // Make sure that all parents are marked as complete
      %parent = %vertex.getParent(%i);
      if(isObject(%parent))
      {
         if(!%parent.isComplete() && !%parent.isMarkedComplete())
         {
            %canMark = false;
            break;
         }
      }         
   } // End for
   
   return %canMark;
}

function TaskRuler::canMarkComplete(%this, %vertex)
{
   if(!isObject(%vertex))
     return false;
     
   // This vertex should be marked as available to be completed
   if(%vertex.isAvailable())
      return true;
   else
      return false;
}

// End svr_taskruler.cs